/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_two_tats;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Optional;

public class DilemmaTitForTwoTatsStrategy
extends DilemmaMemoryStrategy {
    protected DilemmaTitForTwoTatsStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) throws GameException, InterruptedException {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(0, true);
        if (previousRound.forOpponentOf(player).answer().equals((Object)DilemmaAnswerType.DEFECT) && memory.size() > 1 && ((DilemmaRoundData)memory.getRound(1, true)).forOpponentOf(player).answer().equals((Object)DilemmaAnswerType.DEFECT)) {
            return Optional.of(moveFactory.createDefectMove());
        }
        return Optional.of(moveFactory.createCooperateMove());
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}

