/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayerBuilder;
import de.fhdw.gaming.ipspiel23.ssp.domain.impl.SspPlayerImpl;
import de.fhdw.gaming.ipspiel23.ssp.domain.impl.outcomes.SspAnswer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class SspPlayerBuilderImpl
implements SspPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<SspAnswer, Map<SspAnswer, Double>>> possibleOutcomes = Optional.empty();

    SspPlayerBuilderImpl() {
    }

    @Override
    public SspPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public SspPlayerBuilder changePossibleOutcomes(Map<SspAnswer, Map<SspAnswer, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public SspPlayer build() throws GameException {
        return new SspPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<SspAnswer, Map<SspAnswer, Double>> checkPossibleOutcomes(Map<SspAnswer, Map<SspAnswer, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, SspAnswer.PAPER, SspAnswer.PAPER);
        this.checkPossibleOutcome(outcomes, SspAnswer.PAPER, SspAnswer.STONE);
        this.checkPossibleOutcome(outcomes, SspAnswer.PAPER, SspAnswer.SCISSORS);
        this.checkPossibleOutcome(outcomes, SspAnswer.STONE, SspAnswer.STONE);
        this.checkPossibleOutcome(outcomes, SspAnswer.STONE, SspAnswer.PAPER);
        this.checkPossibleOutcome(outcomes, SspAnswer.STONE, SspAnswer.SCISSORS);
        this.checkPossibleOutcome(outcomes, SspAnswer.SCISSORS, SspAnswer.STONE);
        this.checkPossibleOutcome(outcomes, SspAnswer.SCISSORS, SspAnswer.PAPER);
        this.checkPossibleOutcome(outcomes, SspAnswer.SCISSORS, SspAnswer.SCISSORS);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<SspAnswer, Map<SspAnswer, Double>> outcomes, SspAnswer firstChoice, SspAnswer secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, firstChoice.toString(), secondChoice.toString()));
        }
    }
}

