package de.fhdw.gaming.ipspiel23.c4.collections;

import java.util.Map;

import de.fhdw.gaming.ipspiel23.c4.collections.impl.ReadOnlyDictionaryImpl;

/**
 * A factory class for creating {@link IReadOnlyDictionary} instances.
 */
public final class ReadOnlyDictionary {
    
    /**
     * This is a "static" class, so this ctor should never be used.
     */
    private ReadOnlyDictionary() { }

    /**
     * Creates a new {@link IReadOnlyDictionary} instance from the provided map.
     * 
     * @param <TKEY> The type of the keys.
     * @param <TVALUE> The type of the values.
     * @param dictionary The dictionary to wrap.
     * @return The created {@link IReadOnlyDictionary} instance.
     */
    public static <TKEY, TVALUE> IReadOnlyDictionary<TKEY, TVALUE> of(final Map<TKEY, TVALUE> dictionary) {
        return new ReadOnlyDictionaryImpl<TKEY, TVALUE>(dictionary);
    }
}
