package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.cooperate;

import java.util.Optional;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaStrategy;

/**
 * Implements {@link IDilemmaStrategy} by staying silent.
 */
public class DilemmaCooperateStrategy extends DilemmaStrategy {

    /**
     * Creates an {@link DilemmaCooperateStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    DilemmaCooperateStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }
    
    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId,
            final IDilemmaPlayer player,
            final IDilemmaState state) {
        return Optional.of(getMoveFactory().createCooperateMove());
    }

    @Override
    public String toString() {
        return DilemmaCooperateStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object object) {
        if (object instanceof DilemmaCooperateStrategy) {
            final DilemmaCooperateStrategy coopStrategy = (DilemmaCooperateStrategy) object;
            return this.toString().equals(coopStrategy.toString());
        } else {
            return false;
        }
    }
    
    @Override
    public int hashCode() {
        return super.hashCode() * this.toString().hashCode();
    }
}
