/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.grim;

import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundPlayerData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Optional;

public class DilemmaGrimStrategy
extends DilemmaMemoryStrategy {
    DilemmaGrimStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        if (memory.size() == 0) {
            return Optional.of(this.getMoveFactory().createCooperateMove());
        }
        for (int i = 0; i < memory.size(); ++i) {
            DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(i, true);
            DilemmaRoundPlayerData otherPlayersAction = previousRound.forOpponentOf(player);
            if (!otherPlayersAction.answer().equals((Object)DilemmaAnswerType.DEFECT)) continue;
            return Optional.of(this.getMoveFactory().createDefectMove());
        }
        return Optional.of(this.getMoveFactory().createCooperateMove());
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}

