package de.fhdw.gaming.ipspiel23.c4.domain;

import java.util.Optional;

import de.fhdw.gaming.core.domain.Stateful;

/**
 * A field of the connect four game.
 */
public interface IC4Field extends Stateful {

    /**
     * The board that contains this field.
     */
    IC4Board getBoard();

    /**
     * The position of this field on the board.
     */
    IC4Position getBoardPosition();

    /**
     * The player that occupies this field, if any.
     */
    Optional<IC4Player> getOccupyingPlayer();

    /**
     * Tries to set the occupying player of this field.
     * @param player The player to set.
     * @param allowOverride Whether to allow overriding an existing occupying player.
     * @return {@code true} if the occupying player was successfully set, {@code false} if the field was 
     * already occupied and {@code allowOverride} was {@code false} or if setting the occupying player 
     * would violate the rules of the game.
     */
    boolean trySetOccupyingPlayer(IC4Player player, boolean allowOverride);

    /**
     * Whether this field has a neighbor in the given direction (i.e., whether the field is not at the
     * edge of the board).
     * 
     * @param direction The direction to check.
     * @return {@code true} if this field has a neighbor in the given direction, {@code false} otherwise.
     */
    boolean hasNeighbor(C4Direction direction);

    /**
     * Gets the neighbor of this field in the given direction.
     * 
     * @param direction The direction to get the neighbor for.
     * @return The neighbor of this field in the given direction.
     * @throws IllegalArgumentException If this field has no neighbor in the given direction (i.e., if
     * the neighbor would be outside the board).
     */
    IC4Field getNeighbor(C4Direction direction);

    /**
     * Tries to get the neighbor of this field in the given direction.
     * 
     * @param direction The direction to get the neighbor for.
     * @return The neighbor of this field in the given direction, if any.
     */
    Optional<IC4Field> tryGetNeighbor(C4Direction direction);

    @Override
    IC4Field deepCopy();
}
