/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel23.dilemma.domain.internals.DilemmaPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public final class DilemmaPlayerBuilder
implements IDilemmaPlayerBuilder {
    private Optional<String> name;
    private Optional<Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>>> possibleOutcomes;
    private final Map<IDilemmaPlayer, Consumer<IDilemmaStrategy>> playerStrategyHooks;
    private final DilemmaGameBuilder gameBuilder;

    public DilemmaPlayerBuilder(DilemmaGameBuilder parentBuilder) {
        this.gameBuilder = parentBuilder;
        this.name = Optional.empty();
        this.possibleOutcomes = Optional.empty();
        this.playerStrategyHooks = new HashMap<IDilemmaPlayer, Consumer<IDilemmaStrategy>>();
    }

    @Override
    public DilemmaPlayerBuilder changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public DilemmaPlayerBuilder changePossibleOutcomes(Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.ofNullable(newPossibleOutcomes);
        return this;
    }

    @Override
    public IDilemmaPlayer build() throws GameException {
        DilemmaPlayer player = new DilemmaPlayer(this, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
        this.gameBuilder.onPlayerBuilt(this, player);
        return player;
    }

    private Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> checkPossibleOutcomes(Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, DilemmaAnswerType.COOPERATE, DilemmaAnswerType.COOPERATE);
        this.checkPossibleOutcome(outcomes, DilemmaAnswerType.COOPERATE, DilemmaAnswerType.DEFECT);
        this.checkPossibleOutcome(outcomes, DilemmaAnswerType.DEFECT, DilemmaAnswerType.COOPERATE);
        this.checkPossibleOutcome(outcomes, DilemmaAnswerType.DEFECT, DilemmaAnswerType.DEFECT);
        return outcomes;
    }

    void registerPlayerStrategyHook(IDilemmaPlayer player, Consumer<IDilemmaStrategy> value) {
        this.playerStrategyHooks.put(player, value);
    }

    void injectPlayerStrategyUsingHook(IDilemmaPlayer player, IDilemmaStrategy strategy) {
        Consumer playerStrategyHook = this.playerStrategyHooks.getOrDefault(player, null);
        if (playerStrategyHook == null) {
            throw new IllegalStateException("Attempted to inject strategy into player object before hook was configured!");
        }
        playerStrategyHook.accept(strategy);
        this.playerStrategyHooks.remove(player);
    }

    void checkPossibleOutcome(Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> outcomes, DilemmaAnswerType firstChoice, DilemmaAnswerType secondChoice) throws IllegalArgumentException {
        if (outcomes == null || outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name.orElse("Unnamed Player"), firstChoice.toString(), secondChoice.toString()));
        }
    }
}

