/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.imperfect_tit_for_tat;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.tit_for_tat.DilemmaTitForTatStrategy;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import java.util.Optional;
import java.util.Random;

public class DilemmaImperfectTitForTatStrategy
extends DilemmaTitForTatStrategy {
    static final double IMITATION_PROBABILITY = 0.9;
    private static final Random RANDOM = new Random();

    DilemmaImperfectTitForTatStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) throws GameException, InterruptedException {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        IDilemmaMove perfectTftMove = super.computeNextMove(gameId, player, state).get();
        return Optional.of(RANDOM.nextDouble() > 0.9 ? moveFactory.oppositeOf(perfectTftMove) : perfectTftMove);
    }

    @Override
    public String toString() {
        return String.format("%s[imitationProbability: %f]", this.getClass().getSimpleName(), 0.9);
    }
}

