package de.fhdw.gaming.ipspiel23.gst.domain;

import java.util.Collection;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * The Kopplung interface needed for the use of the search tree Project.
 *
 * @param <P> The type of player in the game.
 * @param <S> The type of state in the game.
 */
public interface IKopplung<P extends Player<P>, S extends State<P, S>> {

    /**
     * Retrieves the collection of possible moves in the given game state.
     *
     * @param state The current game state.
     * @return An optional containing the collection of possible moves, or empty if no moves are possible.
     */
    Optional<Collection<Move<P, S>>> getPossibleMoves(S state);

    /**
     * Evaluates the given game state and returns a score indicating the state's desirability.
     *
     * @param state The game state to evaluate.
     * @return An optional containing the evaluation score, or empty if the evaluation is not possible.
     */
    Optional<Integer> evalState(S state);

    /**
     * Retrieves the current player in the given game state.
     *
     * @param state The current game state.
     * @return An optional containing the current player, or empty if the current player cannot be determined.
     */
    Optional<P> getCurrentPlayer(S state);
    
    /** CHecks iff the given game state is game-over.
     * 
     * @param state The current game state.
     * @return An optional containing a Boolean, True iff game is over.
     */
    Optional<Boolean> getIsGameOver(S state);
}
