package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;

/**
 * A position on the connect four board.
 */
public interface IC4Position {
    /**
     * The zero-based row of this position.
     */
    int getRow();

    /**
     * The zero-based column of this position.
     */
    int getColumn();
    
    /**
     * Creates a position.
     * @param row the row of the position
     * @param column the column of the position
     * @return a {@link IC4Position} with the specified row and column.
     */
    static IC4Position create(final int row, final int column) {
        return new C4Position(row, column);
    }
}
