/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import de.fhdw.gaming.core.ui.InputProviderException;

class C4BoardDimensions {
    private int rowCount;
    private int columnCount;

    public C4BoardDimensions(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void assertStaticLimits() throws InputProviderException {
        if (this.rowCount < 2) {
            throw new InputProviderException("The specified number of rows is too small: the number of rows must be at least 2.");
        }
        if (this.columnCount < 2) {
            throw new InputProviderException("The specified number of columns is too small: the number of columns must be at least 2.");
        }
        if (this.rowCount > 0x3FFFFFFF) {
            throw new InputProviderException("The specified number of rows is too large: the number of rows must not exceed 1073741823.");
        }
        if (this.columnCount > 0x3FFFFFFF) {
            throw new InputProviderException("The specified number of columns is too large: the number of columns must not exceed 1073741823.");
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof C4BoardDimensions)) {
            return false;
        }
        C4BoardDimensions other = (C4BoardDimensions)object;
        return this.rowCount == other.rowCount && this.columnCount == other.columnCount;
    }

    public int hashCode() {
        return this.rowCount * 31 + this.columnCount;
    }
}

