/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Game;
import de.fhdw.gaming.ipspiel23.c4.gui.C4BoardEventProvider;
import de.fhdw.gaming.ipspiel23.c4.gui.impl.C4BoardEventProviderImpl;
import de.fhdw.gaming.ipspiel23.c4.gui.impl.C4BoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

public class C4GuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<C4GuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, C4BoardView> boardViews;

    C4GuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<C4GuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, C4BoardView>();
    }

    static Optional<C4BoardEventProvider> getEventProvider(int gameId) {
        C4GuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        C4BoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new C4BoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        if (game instanceof IC4Game) {
            C4BoardView boardView = new C4BoardView((IC4Game)game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        C4BoardView boardView;
        if (game instanceof IC4Game && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused((IC4Game)game);
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        C4BoardView boardView;
        if (game instanceof IC4Game && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed((IC4Game)game);
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        C4BoardView boardView;
        if (game instanceof IC4Game && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy((IC4Game)game);
        }
    }
}

