/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4PlayerBuilder;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Player;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.Optional;
import java.util.function.Consumer;

final class C4PlayerBuilder
implements IC4PlayerBuilder {
    private final int token;
    private Optional<String> name;
    private Consumer<IC4Strategy> playerStrategyHook;

    C4PlayerBuilder(int id) {
        this.token = id;
        this.name = Optional.empty();
    }

    void setPlayerStrategyHook(Consumer<IC4Strategy> value) {
        this.playerStrategyHook = value;
    }

    void injectPlayerStrategyUsingHook(IC4Strategy strategy) {
        if (this.playerStrategyHook == null) {
            throw new IllegalStateException("Attempted to inject strategy into player object before hook was configured!");
        }
        this.playerStrategyHook.accept(strategy);
    }

    @Override
    public IC4PlayerBuilder changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public IC4Player build() throws GameException {
        return new C4Player(this, this.token, this.name.orElseThrow());
    }

    @Override
    public int getToken() {
        return this.token;
    }
}

