/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-Ssp.
 *
 * Ipspiel23-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.ssp.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A SSP {@link GameBuilderFactory} which allows to create a SSP game builder.
 */
public interface SspGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on Stein/Stein.
     */
    String PARAM_PLAYER_OUTCOME_STONE_STONE = "playerOutcomeOnSteinStein";

    /**
     * Player's outcome on Stein/Papier.
     */
    String PARAM_PLAYER_OUTCOME_STONE_PAPER = "playerOutcomeOnSteinPapier";

    /**
     * Player's outcome on Stein/Schere.
     */
    String PARAM_PLAYER_OUTCOME_STONE_SCISSORS = "playerOutcomeOnSteinSchere";

    /**
     * Player's outcome on Papier/Stein.
     */
    String PARAM_PLAYER_OUTCOME_PAPER_STONE = "playerOutcomeOnPapierStein";
    /**
     * Player's outcome on Papier/Papier.
     */
    String PARAM_PLAYER_OUTCOME_PAPER_PAPER = "playerOutcomeOnPapierPapier";
    /**
     * Player's outcome on Papier/Schere.
     */
    String PARAM_PLAYER_OUTCOME_PAPER_SCISSORS = "playerOutcomeOnPapierSchere";

    /**
     * Player's outcome on Papier/Stein.
     */
    String PARAM_PLAYER_OUTCOME_SCISSORS_STONE = "playerOutcomeOnSchereStein";
    /**
     * Player's outcome on Papier/Stein.
     */
    String PARAM_PLAYER_OUTCOME_SCISSORS_PAPER = "playerOutcomeOnScherePapier";
    /**
     * Player's outcome on Papier/Stein.
     */
    String PARAM_PLAYER_OUTCOME_SCISSORS_SCISSORS = "playerOutcomeOnSchereSchere";

    @Override
    SspGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
