/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation;

import de.fhdw.gaming.ipspiel23.c4.domain.C4Direction;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionAnalyzer;

public abstract class C4SolutionAnalyzerDiagonal
extends C4SolutionAnalyzer {
    private final boolean[] isBlacklisted;

    protected C4SolutionAnalyzerDiagonal(C4BoardSlim board, C4Direction searchDirection) {
        super(board, searchDirection);
        int capacity = board.getRowCount() + board.getColumnCount() + 1 - 2 * board.getMinimumSolutionSize();
        this.isBlacklisted = new boolean[capacity];
    }

    public boolean mayContainSolution(int index) {
        return !this.isBlacklisted[index];
    }

    public void noSolutionIn(int index) {
        this.isBlacklisted[index] = true;
    }

    @Override
    public void resetCache() {
        for (int i = 0; i < this.isBlacklisted.length; ++i) {
            this.isBlacklisted[i] = false;
        }
    }
}

