package de.fhdw.gaming.ipspiel23.c4.moves.impl;

import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;

/**
 * The default implementation of {@link IC4MoveFactory}.
 */
public class C4DefaultMoveFactory implements IC4MoveFactory {
    
    @Override
    public IC4Move createMove(final IC4Player player, final IC4Position position) {
        return new C4Move(player, position);
    }

    @Override
    public IC4Move createMove(final IC4Player player, final int row, final int column) {
        return new C4Move(player, row, column);
    }
}
