/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.demo.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class DemoStateImpl
implements DemoState {
    private final DemoPlayer firstPlayer;
    private final DemoPlayer secondPlayer;

    DemoStateImpl(DemoPlayer firstPlayer, DemoPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    DemoStateImpl(DemoStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy();
        this.secondPlayer = source.secondPlayer.deepCopy();
    }

    @Override
    public DemoPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public DemoPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("DemoState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DemoStateImpl) {
            DemoStateImpl other = (DemoStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public DemoState deepCopy() {
        return new DemoStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, DemoPlayer> getPlayers() {
        LinkedHashMap<String, DemoPlayer> result = new LinkedHashMap<String, DemoPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<DemoPlayer> computeNextPlayers() {
        LinkedHashSet<DemoPlayer> playersWithoutMove = new LinkedHashSet<DemoPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<DemoPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            Boolean answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            Boolean answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.firstPlayer.setState(DemoStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.secondPlayer.setState(DemoStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }
}

