package de.fhdw.gaming.ipspiel23.c4.gststrategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import de.fhdw.gaming.ipspiel23.gst.domain.ICalculatorKopplung;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import de.fhdw.gaming.ipspiel23.gst.domain.impl.GstKopplungsMoveCalculator;
import de.fhdw.gaming.ipspiel23.gst.strategies.impl.GstKopplungNegaMaxMultithreading;



/**
 * GSTMoveStrategy for C4 Game.
 */
public class C4GSTMoveStrategy implements IC4Strategy {

    
    
    
    /**
     * The calculator used for computing the next move.
     */
    private final ICalculatorKopplung<IC4Player, IC4State> calc;
    
    /**
     * The C4-GST-Kopplung.
     */
    private final IKopplung<IC4Player, IC4State> c4Kopplung;
    
    /**
     * .
     */
    private final GstKopplungNegaMaxMultithreading<IC4Player, IC4State> negamax;
    //private  GstKopplungNegaMax<IC4Player, IC4State> negamax;
    
    /**
     * Creates new C4GSTMoveStrategy with given MoveFactory.
     * @param moveFactory
     */
    public C4GSTMoveStrategy(final IC4MoveFactory moveFactory) {
        this.c4Kopplung = new C4GSTKopplung(moveFactory);
        
        //this.negamax = new GstKopplungNegaMax<>();
        this.negamax = new GstKopplungNegaMaxMultithreading<>(); 
        this.calc = new GstKopplungsMoveCalculator<>();
        
    }
    
    @Override
    public Optional<IC4Move> computeNextMove(final int gameId, final IC4Player player, final IC4State state)
            throws GameException, InterruptedException {
        
            //final Collection<Move<IC4Player, IC4State>> possibleMoves =   c4Kopplung.getPossibleMoves(state).get();
            
           return Optional.of((IC4Move) calc.calculateMove(c4Kopplung, state, 1000, negamax));
        
          
    }
    
    @Override
    public String toString() {
        return C4GSTMoveStrategy.class.getSimpleName();
    }

}
