/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gststrategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.gststrategy.C4GSTKopplung;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import de.fhdw.gaming.ipspiel23.gst.domain.ICalculatorKopplung;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import de.fhdw.gaming.ipspiel23.gst.domain.impl.GstKopplungsMoveCalculator;
import de.fhdw.gaming.ipspiel23.gst.strategies.impl.GstKopplungNegaMaxMultithreading;
import java.util.Optional;

public class C4GSTMoveStrategy
implements IC4Strategy {
    private final ICalculatorKopplung<IC4Player, IC4State> calc;
    private final IKopplung<IC4Player, IC4State> c4Kopplung;
    private final GstKopplungNegaMaxMultithreading<IC4Player, IC4State> negamax;

    public C4GSTMoveStrategy(IC4MoveFactory moveFactory) {
        this.c4Kopplung = new C4GSTKopplung(moveFactory);
        this.negamax = new GstKopplungNegaMaxMultithreading();
        this.calc = new GstKopplungsMoveCalculator();
    }

    public Optional<IC4Move> computeNextMove(int gameId, IC4Player player, IC4State state) throws GameException, InterruptedException {
        return Optional.of((IC4Move)this.calc.calculateMove(this.c4Kopplung, (State)state, Integer.valueOf(1000), this.negamax));
    }

    public String toString() {
        return C4GSTMoveStrategy.class.getSimpleName();
    }
}

