/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.gui.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.gui.C4BoardEventProvider;
import de.fhdw.gaming.ipspiel23.c4.gui.event.C4BoardEvent;
import de.fhdw.gaming.ipspiel23.c4.gui.event.C4MakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel23.c4.gui.impl.C4BoardView;
import de.fhdw.gaming.ipspiel23.c4.gui.impl.C4FieldView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

public class C4BoardEventProviderImpl
implements C4BoardEventProvider {
    private final C4BoardView boardView;

    public C4BoardEventProviderImpl(C4BoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C4BoardEvent waitForEvent(IC4Player player, IC4State state) {
        Runnable cleanUp;
        LinkedHashMap<IC4Position, C4FieldView> legalFieldViews = new LinkedHashMap<IC4Position, C4FieldView>();
        for (IC4Position position : state.getBoard().getLegalPositions()) {
            legalFieldViews.put(position, this.boardView.getFieldView(position).orElseThrow());
        }
        AtomicReference<C4BoardEvent> event = new AtomicReference<C4BoardEvent>();
        if (legalFieldViews.isEmpty()) {
            List<C4FieldView> fieldViews = this.setupInactiveFields(state.getBoard());
            cleanUp = () -> this.cleanUpFields(fieldViews);
        } else {
            this.setupActiveFields(legalFieldViews, event);
            cleanUp = () -> this.cleanUpFields(legalFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            C4BoardEvent fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            C4BoardEvent c4BoardEvent = null;
            return c4BoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<IC4Position, C4FieldView> emptyFieldViews, AtomicReference<C4BoardEvent> event) {
        for (Map.Entry<IC4Position, C4FieldView> entry : emptyFieldViews.entrySet()) {
            IC4Position position = entry.getKey();
            C4FieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setHighlighted(true);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new C4MakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<C4FieldView> setupInactiveFields(IC4Board board) {
        ArrayList<IC4Field> fields = new ArrayList<IC4Field>();
        for (IC4Field[] ic4Fields : board.getFields()) {
            fields.addAll(Arrays.asList(ic4Fields));
        }
        ArrayList<C4FieldView> fieldViews = new ArrayList<C4FieldView>();
        for (IC4Field field : fields) {
            C4FieldView fieldView = this.boardView.getFieldView(field.getBoardPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(null);
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends C4FieldView> fieldViews) {
        for (C4FieldView c4FieldView : fieldViews) {
            c4FieldView.setCursor(Cursor.DEFAULT);
            c4FieldView.setHighlighted(false);
            c4FieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

