package de.fhdw.gaming.ipspiel23.c4.domain.impl.validation;

import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MIN_COLUMN_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MIN_ROW_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_COLUMN_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_ROW_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_FIELD_COUNT;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MIN_SOLUTION_SIZE;
import static de.fhdw.gaming.ipspiel23.c4.domain.impl.validation.C4BoardLimits.MAX_SOLUTION_SIZE;

/**
 * Provides info for the board validators.
 */
public enum C4BoardValidatorInfo {
    /**
     * Provides info for the row count validator.
     */
    ROW_COUNT {
        @Override
        public String toInfoString(final int playerCount) {
            return String.format("The row count must be greater than or equal to %d.\n"
                    + "The row count must not exceed %d.\n"
                    + "Row count * column count must not exceed %d.\n"
                    + "Row count * column count must be less than %d * solution size.", 
                    MIN_ROW_COUNT, 
                    MAX_ROW_COUNT,
                    MAX_FIELD_COUNT,
                    playerCount);
        }
    },
    /**
     * Provides info for the column count validator.
     */
    COLUMN_COUNT {
        @Override
        public String toInfoString(final int playerCount) {
            return String.format("The column count must be greater than or equal to %d.\n"
                    + "The column count must not exceed %d.\n"
                    + "Row count * column count must not exceed %d.\n"
                    + "Row count * column count must be less than %d * solution size.", 
                    MIN_COLUMN_COUNT, 
                    MAX_COLUMN_COUNT,
                    MAX_FIELD_COUNT,
                    playerCount);
        }
    },
    /**
     * Provides info for the solution size validator.
     */
    SOLUTION_SIZE {
        @Override
        public String toInfoString(final int playerCount) {
            return String.format("The solution size must be greater than or equal to %d.\n"
                    + "The solution size must not exceed %d.\n"
                    + "The solution size must not exceed the numbers of rows and columns on the board.\n"
                    + "%d * solution size must be greater than row count * column count.", 
                    MIN_SOLUTION_SIZE, 
                    MAX_SOLUTION_SIZE,
                    playerCount);
        }
    };
    /**
     * Provides info for the different board validators.
     * @param playerCount the number of players.
     */
    public abstract String toInfoString(int playerCount);
}