/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.collections.IReadOnlyDictionary;
import de.fhdw.gaming.ipspiel23.c4.domain.C4PositionMaterializer;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.evaluation.C4SolutionEvaluator;
import java.util.Set;

public class C4BoardSlim
implements IC4BoardSlim {
    public static final int EMPTY_TOKEN = 0;
    private final int rowCount;
    private final int columnCount;
    private final int[] board;
    private final IReadOnlyDictionary<Integer, IC4Player> players;
    private final int solutionSize;
    private final C4SolutionEvaluator evaluator;

    public C4BoardSlim(IReadOnlyDictionary<Integer, IC4Player> players, int rowCount, int columnCount, int solutionSize) {
        this.players = players;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.board = new int[rowCount * columnCount];
        this.solutionSize = solutionSize;
        this.evaluator = new C4SolutionEvaluator(this);
    }

    public C4BoardSlim(int[] board, IReadOnlyDictionary<Integer, IC4Player> players, int rowCount, int columnCount, int solutionSize) {
        this.board = board;
        this.players = players;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.solutionSize = solutionSize;
        this.evaluator = new C4SolutionEvaluator(this);
    }

    private C4BoardSlim(C4BoardSlim original) {
        this.players = original.players;
        this.rowCount = original.rowCount;
        this.columnCount = original.columnCount;
        this.board = (int[])original.board.clone();
        this.solutionSize = original.solutionSize;
        this.evaluator = new C4SolutionEvaluator(this);
    }

    @Override
    public int emptyToken() {
        return 0;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int[] getBoardStateUnsafe() {
        return this.board;
    }

    @Override
    public int getMinimumSolutionSize() {
        return this.solutionSize;
    }

    @Override
    public IC4BoardSlim deepCopy() {
        return new C4BoardSlim(this);
    }

    @Override
    public void updateTokenUnsafe(int rowIndex, int columnIndex, int value) {
        this.board[rowIndex * this.columnCount + columnIndex] = value;
    }

    @Override
    public IC4Player getPlayerByToken(int fieldState) {
        return this.players.getValueOrDefault(fieldState);
    }

    @Override
    public int getTokenUnsafe(int rowIndex, int columnIndex) {
        return this.board[rowIndex * this.columnCount + columnIndex];
    }

    @Override
    public IC4SolutionSlim tryFindFirstSolution(boolean updateCache) {
        return this.evaluator.tryFindFirstSolution(updateCache);
    }

    @Override
    public IC4SolutionSlim tryFindFirstSolution() {
        return this.evaluator.tryFindFirstSolution(true);
    }

    @Override
    public Set<IC4SolutionSlim> findAllSolutions(boolean updateCache) {
        return this.evaluator.findAllSolutions(updateCache);
    }

    @Override
    public Set<IC4SolutionSlim> findAllSolutions() {
        return this.evaluator.findAllSolutions(true);
    }

    @Override
    public void resetSolutionAnalyzerCaches() {
        this.evaluator.resetAnalyzerCaches();
    }

    @Override
    public boolean isEmptyUnsafe(int row, int column) {
        return this.getTokenUnsafe(row, column) == 0;
    }

    @Override
    public boolean isSolidUnsafe(int row, int column) {
        if (this.checkBounds(row, column)) {
            return !this.isEmptyUnsafe(row, column);
        }
        return this.checkBounds(row - 1, column);
    }

    @Override
    public boolean checkBounds(int row, int column) {
        return row >= 0 && row < this.rowCount && column >= 0 && column < this.columnCount;
    }

    @Override
    public int getDematPositionsByTokenUnsafe(long[] buffer, int token) {
        int index = 0;
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.columnCount; ++col) {
                if (this.getTokenUnsafe(row, col) != token) continue;
                buffer[index] = C4PositionMaterializer.dematerialize(row, col);
                ++index;
            }
        }
        return index;
    }

    @Override
    public int getLegalDematPositionsUnsafe(long[] buffer) {
        int index = 0;
        boolean inAir = false;
        for (int col = 0; col < this.columnCount; ++col) {
            int row;
            for (row = this.rowCount - 1; row >= 0 && !inAir; --row) {
                inAir = this.getTokenUnsafe(row, col) == 0;
            }
            if (!inAir) continue;
            inAir = false;
            buffer[index] = C4PositionMaterializer.dematerialize(row + 1, col);
            ++index;
        }
        return index;
    }

    @Override
    public boolean isFull() {
        for (int col = 0; col < this.columnCount; ++col) {
            if (this.board[col] != 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bobTheBuilder = new StringBuilder(64);
        bobTheBuilder.append("C4BoardSlim[").append(this.getRowCount()).append('x').append(this.getColumnCount()).append("]{\n");
        for (int row = 0; row < this.getRowCount(); ++row) {
            bobTheBuilder.append("  ");
            for (int col = 0; col < this.getColumnCount(); ++col) {
                bobTheBuilder.append(this.getTokenUnsafe(row, col)).append(' ');
            }
            bobTheBuilder.append('\n');
        }
        bobTheBuilder.append('}');
        return bobTheBuilder.toString();
    }
}

