package de.fhdw.gaming.ipspiel23.c4.collections.impl;

import java.util.Collection;
import java.util.Map;

import de.fhdw.gaming.ipspiel23.c4.collections.IReadOnlyDictionary;

/**
 * The default implementation of {@link IReadOnlyDictionary}.
 * 
 * @param <TKEY> The type of the keys.
 * @param <TVALUE> The type of the values.
 */
public class ReadOnlyDictionaryImpl<TKEY, TVALUE> implements IReadOnlyDictionary<TKEY, TVALUE> {

    /**
     * The inner map that is wrapped by this instance.
     */
    private final Map<TKEY, TVALUE> inner;
    
    /**
     * Creates a new instance of {@link ReadOnlyDictionaryImpl}.
     * 
     * @param inner The inner map that is wrapped by this instance.
     */
    public ReadOnlyDictionaryImpl(final Map<TKEY, TVALUE> inner) {
        this.inner = inner;
    }
    
    @Override
    public boolean containsKey(final TKEY key) {
        return inner.containsKey(key);
    }

    @Override
    public TVALUE getValueOrDefault(final TKEY key) {
        return inner.get(key);
    }

    @Override
    public int count() {
        return inner.size();
    }

    @Override
    public Collection<TKEY> getKeys() {
        return inner.keySet();
    }

    @Override
    public Collection<TVALUE> getValues() {
        return inner.values();
    }

    @Override
    public String toString() {
        // "ReadOnlyDictionaryImpl [map={Test=Test}]"
        return String.format("%s [map=%s]", getClass().getSimpleName(), inner);
    }
}
