package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A factory for creating connect four game builders.
 */
public interface IC4GameBuilderFactory extends GameBuilderFactory {

    /**
     * The UI key for the number of rows of the board.
     */
    String PARAM_BOARD_ROWS = "boardRows";

    /**
     * The UI key for the number of columns of the board.
     */
    String PARAM_BOARD_COLUMNS = "boardColumns";

    /**
     * The UI key for the number of players of the board.
     */
    String PARAM_PLAYER_COUNT = "playerCount";

    /**
     * The UI key for the required solution size.
     */
    String PARAM_REQUIRED_SOLUTION_SIZE = "requiredSolutionSize";

    @Override
    IC4GameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}