package de.fhdw.gaming.ipspiel23.c4.domain;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder for configuring a connect four player.
 */
public interface IC4PlayerBuilder {

    /**
     * specifies the name of the player.
     * 
     * @param newName the name of the player
     * @return the same builder instance for fluent configuration
     */
    IC4PlayerBuilder changeName(String newName);
    
    /**
     * Builds the player.
     * @return the player
     * @throws GameException
     */
    IC4Player build() throws GameException;

    /**
     * The unique token/ID of this player.
     * <p>
     * A player's token is used to identify the player in the game and is used internally
     * to indicate what player occupies a field on the board.
     * </p>
     * The token must be unique among all players in the game and must be greater than 0.
     */
    int getToken();
}

