package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * Builder to create a Game.
 * 
 */
public interface FzgGameBuilder extends GameBuilder {

    /**
     * creates a {@link FzgPlayerBuilder} which creates a Player.
     * 
     * @return
     */
    FzgPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player to the game.
     * 
     * @param player The player.
     * @param strategy The players strategy.
     * @throws GameException thrown if adding the player is not allowed.
     */
    FzgGameBuilder addPlayer(FzgPlayer player, FzgStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    FzgGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    FzgGame build(int id) throws GameException, InterruptedException;
}
