package de.fhdw.gaming.ipspiel23.freizeitgestaltung.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.Answer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.factory.AnswerFactory;

/**
 * Implementation for FootballStrategy, Implements {@link FzgStrategy}.
 * 
 */
public class FootballStrategy implements FzgStrategy {
    
    /**
     * Factory for creating answers.
     */
    private final AnswerFactory answerFactory;
    
    /**
     * Contructor.
     * @param answerFactory {@link AnswerFactory} factory to create the answer.
     */
    public FootballStrategy(final AnswerFactory answerFactory) {
        this.answerFactory = answerFactory;
    }

    @Override
    public Optional<Answer> computeNextMove(final int gameId, final FzgPlayer player, final FzgState state)
            throws GameException, InterruptedException {
        return Optional.of(this.answerFactory.createFootballAnswer());
    }
    
    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}
