package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;

/**
 * Represents a FzgPlayer.
 *
 */
public interface FzgPlayer extends Player<FzgPlayer> {

    /**
     * Sets answer for the Player.
     * @param value CINEMA / FOOTBALL
     */
    void setAnswer(AnswerOptions value);
    
    /**
     * Getter for possibleOutcomes.
     * First Key: Answer of first player, second key: Answer of second player.
     * Value outcome for the constellation of answers.
     * @return
     */
    Map<AnswerOptions, Map<AnswerOptions, Double>>getPossibleOutcomes();

    /**
     * Returns the answer of the Player.
     * @return
     */
    Optional<AnswerOptions> getAnswer();
}
