/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.domain.internals;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.MoveChecker;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaGame;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaMoveChecker;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaCooperateMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.internals.DilemmaDefectMove;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class DilemmaGame
extends DefaultGame<IDilemmaPlayer, IDilemmaState, IDilemmaMove, IDilemmaStrategy>
implements IDilemmaGame {
    private static final Random RANDOM = new Random();

    DilemmaGame(int id, IDilemmaState initialState, Map<String, IDilemmaStrategy> strategies, long maxComputationTimePerMove, IDilemmaMoveChecker moveChecker, ObserverFactoryProvider observerFactoryProvider) throws IllegalArgumentException, InterruptedException {
        super(id, (State)initialState, strategies, maxComputationTimePerMove, (MoveChecker)moveChecker, observerFactoryProvider);
    }

    public Optional<IDilemmaMove> chooseRandomMove(IDilemmaPlayer player, IDilemmaState state) {
        return Optional.of(RANDOM.nextBoolean() ? new DilemmaDefectMove() : new DilemmaCooperateMove());
    }

    public String toString() {
        return String.format("DilemmaGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}

