/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.gradual_tit_for_tat;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundPlayerData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Optional;

public class DilemmaGradualTitForTatStrategy
extends DilemmaMemoryStrategy {
    protected DilemmaGradualTitForTatStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) throws GameException, InterruptedException {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(0, true);
        DilemmaRoundPlayerData myPreviousAction = previousRound.forPlayer(player);
        DilemmaRoundPlayerData otherPlayersAction = previousRound.forOpponentOf(player);
        if (myPreviousAction.answer().equals((Object)DilemmaAnswerType.COOPERATE)) {
            if (memory.size() > 1 && ((DilemmaRoundData)memory.getRound(1, true)).forPlayer(player).answer().equals((Object)DilemmaAnswerType.DEFECT)) {
                return Optional.of(moveFactory.createCooperateMove());
            }
            if (otherPlayersAction.answer().equals((Object)DilemmaAnswerType.COOPERATE)) {
                return Optional.of(moveFactory.createCooperateMove());
            }
            return Optional.of(moveFactory.createDefectMove());
        }
        if (DilemmaGradualTitForTatStrategy.continuePunishingOpponent(player, memory)) {
            return Optional.of(moveFactory.createDefectMove());
        }
        return Optional.of(moveFactory.createCooperateMove());
    }

    private static boolean continuePunishingOpponent(IDilemmaPlayer player, IGameMemory<DilemmaRoundData> memory) {
        int punishCounter;
        for (punishCounter = 0; punishCounter < memory.size() && ((DilemmaRoundData)memory.getRound(punishCounter, true)).forPlayer(player).answer().equals((Object)DilemmaAnswerType.DEFECT); ++punishCounter) {
        }
        int defectsBeforePunishment = 0;
        for (int i = punishCounter; i < memory.size(); ++i) {
            if (!((DilemmaRoundData)memory.getRound(i, true)).forOpponentOf(player).answer().equals((Object)DilemmaAnswerType.DEFECT)) continue;
            ++defectsBeforePunishment;
        }
        return punishCounter < defectsBeforePunishment;
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.unlimited();
    }
}

