/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals;

import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundPlayerData;

public record DilemmaRoundData(DilemmaRoundPlayerData player1Data, DilemmaRoundPlayerData player2Data) {
    public DilemmaRoundPlayerData forPlayer(IDilemmaPlayer player) {
        if (this.player1Data.player().getName().equals(player.getName())) {
            return this.player1Data;
        }
        if (this.player2Data.player().getName().equals(player.getName())) {
            return this.player2Data;
        }
        throw new IllegalArgumentException("Unknown player: " + player);
    }

    public DilemmaRoundPlayerData forOpponentOf(IDilemmaPlayer player) {
        if (this.player1Data.player().getName().equals(player.getName())) {
            return this.player2Data;
        }
        if (this.player2Data.player().getName().equals(player.getName())) {
            return this.player1Data;
        }
        throw new IllegalArgumentException("Unknown player: " + player);
    }

    public static DilemmaRoundData fromRaw(IDilemmaPlayer player1, IDilemmaMove player1Move, IDilemmaPlayer player2, IDilemmaMove player2Move) {
        DilemmaAnswerType player1Answer = player1Move == null ? null : player1Move.getAnswer();
        DilemmaAnswerType player2Answer = player2Move == null ? null : player2Move.getAnswer();
        DilemmaRoundPlayerData player1Data = new DilemmaRoundPlayerData(player1, player1Answer, player1Move);
        DilemmaRoundPlayerData player2Data = new DilemmaRoundPlayerData(player2, player2Answer, player2Move);
        return new DilemmaRoundData(player1Data, player2Data);
    }
}

