package de.fhdw.gaming.ipspiel23.gst.strategies.domain;

import java.util.Optional;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;

/**
 * An interface for implementing a generic mini-max strategy.
 *
 * @param <P> The type of player in the game.
 * @param <S> The type of state in the game.
 */
public interface IGstKopplungsMiniMaxStrategy<P extends Player<P>,
        S extends State<P, S>> {

    /**
     * Calculates the best move for a player in a given state using the mini-max strategy.
     *
     * @param kopplung               The game object representing the specific game being played.
     * @param state                  The current state of the game.
     * @param maximumComputationTime The maximum computation time allowed for calculating the move.
     * @return An optional containing the calculated best move, or empty if no move is available.
     */
    Optional<Move<P, S>> calculateBestMove(IKopplung<P, S> kopplung, S state,
            int maximumComputationTime);
}
