/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.gst.strategies.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import de.fhdw.gaming.ipspiel23.gst.strategies.domain.IGstKopplungsMiniMaxStrategy;
import java.util.Collection;
import java.util.Optional;

public class GstKopplungNegaMax<P extends Player<P>, S extends State<P, S>>
implements IGstKopplungsMiniMaxStrategy<P, S> {
    @Override
    public Optional<Move<P, S>> calculateBestMove(IKopplung<P, S> kopplung, S state, int maximumComputationTime) {
        Optional<Object> bestMove = Optional.empty();
        try {
            Optional<Collection<Move<P, S>>> possiblesMovesOptional = kopplung.getPossibleMoves((State)state);
            if (possiblesMovesOptional.isPresent() && possiblesMovesOptional.get().size() > 0) {
                for (int i = 0; i < 10; ++i) {
                    Integer bestMoveScore = Integer.MIN_VALUE;
                    Optional<Object> iterationBestMove = Optional.empty();
                    Integer iterationBestMoveScore = Integer.MIN_VALUE;
                    for (Move<P, S> move : possiblesMovesOptional.get()) {
                        State copiedState = state.deepCopy();
                        Player currentPlayer = (Player)kopplung.getCurrentPlayer(copiedState).get();
                        move.applyTo(copiedState, currentPlayer);
                        copiedState.nextTurn();
                        Integer moveScore = -this.negamax(kopplung, copiedState, i, Integer.MIN_VALUE, Integer.MAX_VALUE).intValue();
                        if (moveScore <= iterationBestMoveScore) continue;
                        iterationBestMove = Optional.of(move);
                        iterationBestMoveScore = moveScore;
                    }
                    if (iterationBestMoveScore <= bestMoveScore) continue;
                    bestMove = iterationBestMove;
                }
            }
            return bestMove;
        }
        catch (Exception e) {
            return bestMove;
        }
    }

    private S simulateMove(IKopplung<P, S> kopplung, S state, Move<P, S> move) throws GameException {
        State copiedState = state.deepCopy();
        Player currentPlayer = (Player)kopplung.getCurrentPlayer(copiedState).get();
        move.applyTo(copiedState, currentPlayer);
        copiedState.nextTurn();
        return (S)copiedState;
    }

    private Integer negamax(IKopplung<P, S> kopplung, S state, Integer depth, Integer alpha, Integer beta) throws GameException {
        if (depth == 0 || kopplung.getIsGameOver(state).get().booleanValue()) {
            return kopplung.evalState(state).get();
        }
        Optional<Collection<Move<P, S>>> possiblesMovesOptional = kopplung.getPossibleMoves(state);
        if (possiblesMovesOptional.isPresent() && possiblesMovesOptional.get().size() > 0) {
            Integer score = Integer.MIN_VALUE;
            Integer modAlpha = alpha;
            for (Move<P, S> move : possiblesMovesOptional.get()) {
                S copiedState = this.simulateMove(kopplung, state, move);
                Integer childScore = -this.negamax(kopplung, copiedState, depth - 1, -beta.intValue(), -modAlpha.intValue()).intValue();
                if (childScore > score) {
                    score = childScore + depth;
                }
                if ((modAlpha = Integer.valueOf(Math.max(modAlpha, score))) < beta) continue;
                break;
            }
            return score;
        }
        throw new GameException("Something went wrong with  Negamax");
    }
}

