/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.gst.strategies.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.gst.domain.IKopplung;
import de.fhdw.gaming.ipspiel23.gst.strategies.domain.IGstKopplungsMiniMaxStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class GstKopplungNegaMaxMultithreading<P extends Player<P>, S extends State<P, S>>
implements IGstKopplungsMiniMaxStrategy<P, S> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Move<P, S>> calculateBestMove(IKopplung<P, S> kopplung, S state, int maximumComputationTime) {
        Optional<Move<P, S>> bestMove = Optional.empty();
        AtomicReference<Integer> bestMoveScore = new AtomicReference<Integer>(Integer.MIN_VALUE);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            Long startTime = System.currentTimeMillis();
            Optional<Collection<Move<P, State>>> possiblesMovesOptional = kopplung.getPossibleMoves((State)state);
            if (possiblesMovesOptional.isPresent() && !possiblesMovesOptional.get().isEmpty()) {
                int i = 0;
                while (true) {
                    Integer depth = i;
                    if (System.currentTimeMillis() - startTime > (long)(maximumComputationTime / 2)) break;
                    ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
                    ArrayList<Move<P, State>> moves = new ArrayList<Move<P, State>>(possiblesMovesOptional.get());
                    for (Move move : moves) {
                        State copiedState = state.deepCopy();
                        Player currentPlayer = (Player)kopplung.getCurrentPlayer(copiedState).get();
                        move.applyTo(copiedState, currentPlayer);
                        copiedState.nextTurn();
                        futures.add(executorService.submit(() -> -this.negamax(kopplung, copiedState, depth, Integer.MIN_VALUE, Integer.MAX_VALUE).intValue()));
                    }
                    for (Future future : futures) {
                        Integer moveScore = (Integer)future.get();
                        if (moveScore <= bestMoveScore.get()) continue;
                        bestMoveScore.set(moveScore);
                        bestMove = Optional.of((Move)moves.get(futures.indexOf(future)));
                    }
                    ++i;
                }
            }
            Optional<Move<P, S>> optional = bestMove;
            return optional;
        }
        catch (Exception e) {
            e.printStackTrace();
            Optional<Move<P, S>> optional = bestMove;
            return optional;
        }
        finally {
            executorService.shutdown();
        }
    }

    private S simulateMove(IKopplung<P, S> kopplung, S state, Move<P, S> move) throws GameException {
        State copiedState = state.deepCopy();
        Player currentPlayer = (Player)kopplung.getCurrentPlayer(copiedState).get();
        move.applyTo(copiedState, currentPlayer);
        copiedState.nextTurn();
        return (S)copiedState;
    }

    private Integer negamax(IKopplung<P, S> kopplung, S state, Integer depth, Integer alpha, Integer beta) throws GameException {
        Optional<Collection<Move<P, S>>> possiblesMovesOptional = kopplung.getPossibleMoves(state);
        if (depth == 0 || kopplung.getIsGameOver(state).get().booleanValue()) {
            return kopplung.evalState(state).get();
        }
        if (possiblesMovesOptional.isPresent() && possiblesMovesOptional.get().size() > 0) {
            Integer score = Integer.MIN_VALUE;
            Integer modAlpha = alpha;
            for (Move<P, S> move : possiblesMovesOptional.get()) {
                S copiedState = this.simulateMove(kopplung, state, move);
                Integer childScore = -this.negamax(kopplung, copiedState, depth - 1, -beta.intValue(), -modAlpha.intValue()).intValue();
                if (childScore > score) {
                    score = childScore - depth;
                }
                if ((modAlpha = Integer.valueOf(Math.max(modAlpha, score))) < beta) continue;
                break;
            }
            return score;
        }
        throw new GameException("Something went wrong with  Negamax");
    }
}

