/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel23-Ssp.
 *
 * Ipspiel23-Ssp is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel23-Ssp is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel23-Ssp. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel23.ssp.strategy;

import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel23.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel23.ssp.moves.factory.SspMoveFactory;

import java.util.Optional;

/**
 * Implements {@link SspStrategy} by always saying "stone".
 */
public final class SspSayStoneStrategy implements SspStrategy {

    /**
     * The factory for creating SSP moves.
     */
    private final SspMoveFactory moveFactory;

    /**
     * Creates an {@link SspSayStoneStrategy}.
     *
     * @param moveFactory The factory for creating SSP moves.
     */
    SspSayStoneStrategy(final SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<SspMove> computeNextMove(final int gameId, final SspPlayer player, final SspState state) {
        return Optional.of(this.moveFactory.createStoneMove());
    }

    @Override
    public String toString() {
        return SspSayStoneStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {

        return super.hashCode() * this.toString().hashCode();
    }
}
