package de.fhdw.gaming.ipspiel23.ssp.strategy;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspPlayer;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspState;
import de.fhdw.gaming.ipspiel23.ssp.domain.SspStrategy;
import de.fhdw.gaming.ipspiel23.ssp.moves.SspMove;
import de.fhdw.gaming.ipspiel23.ssp.moves.factory.SspMoveFactory;

/**
 * Implements {@link SspStrategy} by always choosing a random Answer.
 * 
 * @author DW
 *
 */
public final class SspMixedStrategy implements SspStrategy {

    /**
     * The random generator used to create random SSP moves.
     * 
     */
    private static final Random RANDOM = new Random();

    /**
     * The factory for creating SSP moves.
     */
    private final SspMoveFactory moveFactory;

    /**
     * Creates an {@link SspMixedStrategy}.
     *
     * @param moveFactory The factory for creating SSP moves.
     */
    SspMixedStrategy(final SspMoveFactory moveFactory) {
        this.moveFactory = moveFactory;

    }

    /**
     * Computes a random next move.
     */
    @Override
    public Optional<SspMove> computeNextMove(final int gameId, final SspPlayer player, final SspState state)
            throws GameException, InterruptedException {
        final List<Supplier<SspMove>> moveSuppliers = List.of(
            moveFactory::createPaperMove,
            moveFactory::createScissorsMove, 
            moveFactory::createStoneMove);
        return Optional.of(moveSuppliers.get(RANDOM.nextInt(moveSuppliers.size())).get());
    }

    @Override
    public String toString() {
        return SspMixedStrategy.class.getSimpleName();
    }

    @Override
    public boolean equals(final Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {

        return super.hashCode() * this.toString().hashCode();
    }
}
