package de.fhdw.gaming.ipspiel23.dilemma.moves.internals;

import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;

// no shit sherlock
/**
 * implements {@link IDilemmaMoveFactory}.
 */
public class DilemmaDefaultMoveFactory implements IDilemmaMoveFactory {

    @Override
    public DilemmaDefectMove createDefectMove() {
        return new DilemmaDefectMove();
    }

    @Override
    public DilemmaCooperateMove createCooperateMove() {
        return new DilemmaCooperateMove();
    }

    @Override
    public IDilemmaMove sameAs(final IDilemmaMove move) {
        return move.getAnswer().equals(DilemmaAnswerType.COOPERATE)
            ? createCooperateMove()
            : createDefectMove();
    }

    @Override
    public IDilemmaMove oppositeOf(final IDilemmaMove move) {
        return move.getAnswer().equals(DilemmaAnswerType.COOPERATE)
            ? createDefectMove()
            : createCooperateMove();
    }

    @Override
    public IDilemmaMove fromAnswer(final DilemmaAnswerType answer) {
        return answer.equals(DilemmaAnswerType.COOPERATE)
            ? createCooperateMove()
            : createDefectMove();
    }
}
