package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.two_tits_for_tat;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;

import static de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType.DEFECT;
/**
 * Defects twice after being defected against, otherwise cooperates.
 */
public class DilemmaTwoTitsForTatStrategy extends DilemmaMemoryStrategy {

    /**
     * Creates a new instance of the {@link DilemmaTwoTitsForTatStrategy} class.
     * @param moveFactory the move factory to use.
     */
    protected DilemmaTwoTitsForTatStrategy(final IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    public Optional<IDilemmaMove> computeNextMove(final int gameId, final IDilemmaPlayer player, 
            final IDilemmaState state)
            throws GameException, InterruptedException {
        final IGameMemory<DilemmaRoundData> memory = getMemoryForPlayer(player, state);
        final IDilemmaMoveFactory moveFactory = getMoveFactory();
        // cooperate on the first round ...
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        final DilemmaRoundData previousRound = memory.getRound(0, true);
        
        // ...and defects twice in a row if the opponent defects one.
        // check if opponent defected at least once in the previous two rounds
        if (previousRound.forOpponentOf(player).answer().equals(DEFECT) 
            || memory.size() > 1
                && memory.getRound(1, true).forOpponentOf(player).answer().equals(DEFECT)) {
            return Optional.of(getMoveFactory().createDefectMove());
        } else {
            return Optional.of(getMoveFactory().createCooperateMove());
        }

    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.of(2);
    }
}
