/*
 * Copyright © 2020-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of othello-core.
 *
 * Othello-core is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Othello-core is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * othello-core. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * MuenzwurfPlayer.
 */
public interface MuenzwurfPlayer extends Player<MuenzwurfPlayer> {
    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<MuenzwurfSide, Map<MuenzwurfSide, Double>> getPossibleOutcomes();

    /**
     * Returns the side chosen by the player.
     */
    Optional<MuenzwurfSide> getSide();
    
    /**
     * Gets pointsForSame.
     * @return The boolean currently save for pointsForSame.
     */
    Boolean getPointsForSame();
    
    /**
     * Sets pointsForSame.
     * @param toSet The boolean to set pointsForSame to.
     */
    void setPointsForSame(Boolean toSet);
    
    /**
     * Sets the answer of this player.
     *
     * @param side The side to set. {@code Side.HEADS} means Heads, {@code Side.HEADS} means Tails
     * @throws IllegalStateException if an answer has already been set.
     */
    void chooseSide(MuenzwurfSide side) throws IllegalStateException;

    @Override
    MuenzwurfPlayer deepCopy();
}
