/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.GefangenenDilemma.domain.impl;

import de.fhdw.gaming.GefangenenDilemma.domain.GDGameBuilder;
import de.fhdw.gaming.GefangenenDilemma.domain.GDGameBuilderFactory;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.GefangenenDilemma.domain.GDPlayerBuilder;
import de.fhdw.gaming.GefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.GefangenenDilemma.domain.factory.GDDefaultStrategyFactoryProvider;
import de.fhdw.gaming.GefangenenDilemma.domain.factory.GDStrategyFactory;
import de.fhdw.gaming.GefangenenDilemma.domain.factory.GDStrategyFactoryProvider;
import de.fhdw.gaming.GefangenenDilemma.domain.impl.GDGameBuilderImpl;
import de.fhdw.gaming.GefangenenDilemma.moves.impl.GDDefaultMoveFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class GDGameBuilderFactoryImpl
implements GDGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<GDStrategy> strategies;

    public GDGameBuilderFactoryImpl() {
        this(new GDDefaultStrategyFactoryProvider());
    }

    GDGameBuilderFactoryImpl(GDStrategyFactoryProvider strategyFactoryProvider) {
        GDDefaultMoveFactory moveFactory = new GDDefaultMoveFactory();
        List<GDStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<GDStrategy>();
        for (GDStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "GefangenenDilemma";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<GDStrategy>(this.strategies);
    }

    @Override
    public GDGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            GDGameBuilderImpl gameBuilder = new GDGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            GDPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            GDStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            GDPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            GDStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Gefangenen-Dilemma game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnSnitchSnitch", "Player's outcome on Snitch/Snitch", Optional.of(-8), new Validator[0]).needInteger("playerOutcomeOnSnitchRemainSilent", "Player's outcome on Snitch/RemainSilent", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnRemainSilentSnitch", "Player's outcome on RemainSilent/Snitch", Optional.of(-10), new Validator[0]).needInteger("playerOutcomeOnRemainSilentRemainSilent", "Player's outcome on RemainSilent/RemainSilent", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private GDPlayer createPlayer(GDPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<MOVES, Map<MOVES, Double>> possibleOutcomes = new LinkedHashMap<MOVES, Map<MOVES, Double>>();
        LinkedHashMap<MOVES, Double> possibleOutcomesSnitch = new LinkedHashMap<MOVES, Double>();
        possibleOutcomesSnitch.put(MOVES.SNITCH, Double.valueOf(((Integer)playerData.get("playerOutcomeOnSnitchSnitch")).intValue()));
        possibleOutcomesSnitch.put(MOVES.REMAINSILENT, Double.valueOf(((Integer)playerData.get("playerOutcomeOnSnitchRemainSilent")).intValue()));
        possibleOutcomes.put(MOVES.SNITCH, possibleOutcomesSnitch);
        LinkedHashMap<MOVES, Double> possibleOutcomesRemainSilent = new LinkedHashMap<MOVES, Double>();
        possibleOutcomesRemainSilent.put(MOVES.SNITCH, Double.valueOf(((Integer)playerData.get("playerOutcomeOnRemainSilentSnitch")).intValue()));
        possibleOutcomesRemainSilent.put(MOVES.REMAINSILENT, Double.valueOf(((Integer)playerData.get("playerOutcomeOnRemainSilentRemainSilent")).intValue()));
        possibleOutcomes.put(MOVES.REMAINSILENT, possibleOutcomesRemainSilent);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private GDStrategy getStrategy(Map<String, Object> playerData) {
        return (GDStrategy)playerData.get("playerStrategy");
    }

    public static enum MOVES {
        SNITCH,
        REMAINSILENT;

    }
}

