package de.fhdw.gaming.ipspiel24.fg.strategy;

import java.security.SecureRandom;
import java.util.Optional;

import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import de.fhdw.gaming.ipspiel24.fg.domain.FGState;
import de.fhdw.gaming.ipspiel24.fg.domain.FGStrategy;
import de.fhdw.gaming.ipspiel24.fg.moves.FGMove;
import de.fhdw.gaming.ipspiel24.fg.moves.factory.FGMoveFactory;

/**
 * Cinema Strategy.
 */
public class FGmixedCinemaStrategy implements FGStrategy {

    /**
     * The factory for creating FG moves.
     */
    private final FGMoveFactory moveFactory;
    private final SecureRandom random;

    /**
     * Creates an {@link FGSayYesStrategy}.
     *
     * @param moveFactory The factory for creating FG moves.
     */
    FGmixedCinemaStrategy(final FGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.random = new SecureRandom();
    }

    @Override
    public Optional<FGMove> computeNextMove(
            final int gameId,
            final FGPlayer player,
            final FGState state,
            final long maxComputationTimePerMove) {
        if (random.nextInt(3) < 2) {
            return Optional.of(this.moveFactory.createCinemaMove());
        } else {
            return Optional.of(this.moveFactory.createFootballMove());
        }
    }

    @Override
    public String toString() {
        return FGmixedCinemaStrategy.class.getSimpleName();
    }
}
