/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.strategy;

import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfState;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfStrategy;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.factory.MuenzwurfMoveFactory;
import java.util.Optional;
import java.util.Random;

public final class MuenzwurfChooseRandomStrategy
implements MuenzwurfStrategy {
    private final MuenzwurfMoveFactory moveFactory;
    private final Random randomGenerator = new Random();

    MuenzwurfChooseRandomStrategy(MuenzwurfMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<MuenzwurfMove> computeNextMove(int gameId, MuenzwurfPlayer player, MuenzwurfState state, long maxComputationTimePerMove) {
        int randomNumber = this.randomGenerator.nextInt(3);
        if (randomNumber == 0) {
            return Optional.of(this.moveFactory.createHeadsMove());
        }
        if (randomNumber == 1) {
            return Optional.of(this.moveFactory.createTailsMove());
        }
        if (randomNumber == 2) {
            return Optional.of(this.moveFactory.createEdgeMove());
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        return MuenzwurfChooseRandomStrategy.class.getSimpleName();
    }
}

