/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-demo.
 *
 * Ipspiel24-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-demo. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.muenzwurf.core.strategy;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfPlayer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfState;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.domain.MuenzwurfStrategy;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.factory.MuenzwurfMoveFactory;

/**
 * Implements {@link DemoStrategy} by always saying "no".
 */
public final class MuenzwurfChooseRandomStrategy implements MuenzwurfStrategy {

    /**
     * The factory for creating Demo moves.
     */
    private final MuenzwurfMoveFactory moveFactory;
    
    /**
     * Random-object to generate a random choice.
     */
    private final Random randomGenerator = new Random();

    /**
     * Creates an {@link MuenzwurfChooseRandomStrategy}.
     *
     * @param moveFactory The factory for creating Demo moves.
     */
    MuenzwurfChooseRandomStrategy(final MuenzwurfMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<MuenzwurfMove> computeNextMove(
            final int gameId,
            final MuenzwurfPlayer player,
            final MuenzwurfState state,
            final long maxComputationTimePerMove) {
        
        final int randomNumber = randomGenerator.nextInt(3);
        
        if (randomNumber == 0) {
            return Optional.of(this.moveFactory.createHeadsMove()); 
        } else if (randomNumber == 1) { 
            return Optional.of(this.moveFactory.createTailsMove()); 
        } else if (randomNumber == 2) { 
            return Optional.of(this.moveFactory.createEdgeMove()); 
        } else  {
            throw new IndexOutOfBoundsException();
        }
        
    }

    @Override
    public String toString() {
        return MuenzwurfChooseRandomStrategy.class.getSimpleName();
    }
}
