/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.fg.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel24.fg.domain.FGActivity;
import de.fhdw.gaming.ipspiel24.fg.domain.FGPlayer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class FGPlayerImpl
extends AbstractPlayer<FGPlayer>
implements FGPlayer {
    private final Map<FGActivity, Map<FGActivity, Double>> possibleOutcomes;
    private Optional<FGActivity> answer;

    FGPlayerImpl(String name, Map<FGActivity, Map<FGActivity, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<FGActivity, Map<FGActivity, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    FGPlayerImpl(FGPlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("FGPlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FGPlayerImpl) {
            FGPlayerImpl other = (FGPlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer) && this.possibleOutcomes.equals(other.possibleOutcomes);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ Objects.hash(this.answer, this.possibleOutcomes);
    }

    @Override
    public Map<FGActivity, Map<FGActivity, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<FGActivity> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(FGActivity newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    @Override
    public FGPlayer deepCopy() {
        return new FGPlayerImpl(this);
    }
}

