package de.fhdw.gaming.ipspiel24.muenzwurf.core.domain;

import java.util.List;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.ipspiel24.muenzwurf.core.moves.MuenzwurfMove;

/**
 * A builder which allows to create a Demo game.
 */
public interface MuenzwurfGameBuilder extends GameBuilder {

    /**
     * Creates an {@link MuenzwurfPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    MuenzwurfPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    MuenzwurfGameBuilder addPlayer(MuenzwurfPlayer player, MuenzwurfStrategy strategy) throws GameException;

    @Override
    MuenzwurfGameBuilder addObservers(List<Observer> newObservers);

    @Override
    Game<MuenzwurfPlayer, MuenzwurfState, MuenzwurfMove, MuenzwurfStrategy> build(int id)
            throws GameException, InterruptedException;
}
