/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-VierConnects-gui.
 *
 * ipspiel24-VierConnects-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel24-VierConnects-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel24-VierConnects-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui;

import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.event.VierConnectsBoardEvent;

/**
 * Provides input from the user interacting with a Vier Connects board.
 */
public interface VierConnectsBoardEventProvider {

    /**
     * Waits for a user event and returns it.
     *
     * @param player It is this player's turn.
     * @param state  A copy of the game state.
     * @return The {@link VierConnectsBoardEvent} generated by the user.
     */
    VierConnectsBoardEvent waitForEvent(VierConnectsPlayer player, VierConnectsState state);

    /**
     * If the provider is currently waiting for a user event, the wait operation will be cancelled.
     */
    void cancelWaiting();
}
