/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui.impl;

import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsBoard;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsField;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsFieldState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPosition;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.VierConnectsBoardEventProvider;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.event.VierConnectsBoardEvent;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.event.VierConnectsMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.impl.VierConnectsBoardView;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.impl.VierConnectsFieldView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;

final class VierConnectsBoardEventProviderImpl
implements VierConnectsBoardEventProvider {
    private final VierConnectsBoardView boardView;

    VierConnectsBoardEventProviderImpl(VierConnectsBoardView boardView) {
        this.boardView = boardView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VierConnectsBoardEvent waitForEvent(VierConnectsPlayer player, VierConnectsState state) {
        Runnable cleanUp;
        Object fieldViews;
        LinkedHashMap<VierConnectsPosition, VierConnectsFieldView> emptyFieldViews = new LinkedHashMap<VierConnectsPosition, VierConnectsFieldView>();
        for (Map.Entry entry : state.getBoard().getFieldsBeing(VierConnectsFieldState.EMPTY).entrySet()) {
            emptyFieldViews.put((VierConnectsPosition)entry.getKey(), this.boardView.getFieldView((VierConnectsPosition)entry.getKey()).orElseThrow());
        }
        AtomicReference<VierConnectsBoardEvent> event = new AtomicReference<VierConnectsBoardEvent>();
        if (emptyFieldViews.isEmpty()) {
            fieldViews = this.setupInactiveFields(state.getBoard());
            cleanUp = () -> this.cleanUpFields((Collection<? extends VierConnectsFieldView>)fieldViews);
        } else {
            this.setupActiveFields(emptyFieldViews, event);
            cleanUp = () -> this.cleanUpFields(emptyFieldViews.values());
        }
        try {
            this.boardView.getUserInputSemaphore().acquire();
            fieldViews = event.get();
            return fieldViews;
        }
        catch (InterruptedException e) {
            VierConnectsBoardEvent vierConnectsBoardEvent = null;
            return vierConnectsBoardEvent;
        }
        finally {
            Platform.runLater((Runnable)cleanUp);
        }
    }

    private void setupActiveFields(Map<VierConnectsPosition, VierConnectsFieldView> emptyFieldViews, AtomicReference<VierConnectsBoardEvent> event) {
        for (Map.Entry<VierConnectsPosition, VierConnectsFieldView> entry : emptyFieldViews.entrySet()) {
            VierConnectsPosition position = entry.getKey();
            VierConnectsFieldView fieldView = entry.getValue();
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CROSSHAIR);
                fieldView.setHighlighted(true);
                fieldView.setOnMouseClicked(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        event.set(new VierConnectsMakeMoveBoardEvent(position));
                        this.boardView.getUserInputSemaphore().release();
                    }
                });
            });
        }
    }

    private List<VierConnectsFieldView> setupInactiveFields(VierConnectsBoard board) {
        ArrayList fields = new ArrayList();
        board.getFields().forEach(list -> fields.addAll(list));
        ArrayList<VierConnectsFieldView> fieldViews = new ArrayList<VierConnectsFieldView>();
        for (VierConnectsField field : fields) {
            VierConnectsFieldView fieldView = this.boardView.getFieldView(field.getPosition()).orElseThrow();
            fieldViews.add(fieldView);
            Platform.runLater(() -> {
                fieldView.setCursor(Cursor.CLOSED_HAND);
                fieldView.setOnMouseClicked(null);
            });
        }
        return fieldViews;
    }

    private void cleanUpFields(Collection<? extends VierConnectsFieldView> fieldViews) {
        for (VierConnectsFieldView vierConnectsFieldView : fieldViews) {
            vierConnectsFieldView.setCursor(Cursor.DEFAULT);
            vierConnectsFieldView.setHighlighted(false);
            vierConnectsFieldView.setOnMouseClicked(null);
        }
    }

    @Override
    public void cancelWaiting() {
        this.boardView.getUserInputSemaphore().release();
    }
}

