/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsStrategy;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.VierConnectsMove;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.VierConnectsBoardEventProvider;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.impl.VierConnectsBoardEventProviderImpl;
import de.fhdw.gaming.ipspiel24.VierConnects.gui.impl.VierConnectsBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class VierConnectsGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<VierConnectsGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, VierConnectsBoardView> boardViews;

    VierConnectsGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<VierConnectsGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, VierConnectsBoardView>();
    }

    static Optional<VierConnectsBoardEventProvider> getEventProvider(int gameId) {
        VierConnectsGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        VierConnectsBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new VierConnectsBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        Optional<Game<VierConnectsPlayer, VierConnectsState, VierConnectsMove, VierConnectsStrategy>> vierConnectsGame = VierConnectsGuiObserverImpl.toVierConnectsGame(game);
        if (vierConnectsGame.isPresent()) {
            VierConnectsBoardView boardView = new VierConnectsBoardView(vierConnectsGame.get());
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        VierConnectsBoardView boardView;
        Optional<Game<VierConnectsPlayer, VierConnectsState, VierConnectsMove, VierConnectsStrategy>> vierConnectsGame = VierConnectsGuiObserverImpl.toVierConnectsGame(game);
        if (vierConnectsGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused(vierConnectsGame.get());
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        VierConnectsBoardView boardView;
        Optional<Game<VierConnectsPlayer, VierConnectsState, VierConnectsMove, VierConnectsStrategy>> vierConnectsGame = VierConnectsGuiObserverImpl.toVierConnectsGame(game);
        if (vierConnectsGame.isPresent() && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed(vierConnectsGame.get());
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        VierConnectsBoardView boardView;
        Optional<Game<VierConnectsPlayer, VierConnectsState, VierConnectsMove, VierConnectsStrategy>> vierConnectsGame = VierConnectsGuiObserverImpl.toVierConnectsGame(game);
        if (vierConnectsGame.isPresent() && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy(vierConnectsGame.get());
        }
    }

    private static Optional<Game<VierConnectsPlayer, VierConnectsState, VierConnectsMove, VierConnectsStrategy>> toVierConnectsGame(Game<?, ?, ?, ?> game) {
        if (game.getState() instanceof VierConnectsState) {
            Game<?, ?, ?, ?> vierConnectsGame = game;
            return Optional.of(vierConnectsGame);
        }
        return Optional.empty();
    }
}

