/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel24.VierConnects.strategy.random;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsField;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsFieldState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsPlayer;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsState;
import de.fhdw.gaming.ipspiel24.VierConnects.core.domain.VierConnectsStrategy;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.VierConnectsMove;
import de.fhdw.gaming.ipspiel24.VierConnects.core.moves.factory.VierConnectsMoveFactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;

public final class VierConnectsRandomMoveStrategy
implements VierConnectsStrategy {
    private static final Random RANDOM = new Random();
    private final VierConnectsMoveFactory moveFactory;

    VierConnectsRandomMoveStrategy(VierConnectsMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<VierConnectsMove> computeNextMove(int gameId, VierConnectsPlayer player, VierConnectsState state, long maxComputationTimePerMove) throws GameException {
        ArrayList fields = new ArrayList(state.getBoard().getFieldsBeing(VierConnectsFieldState.EMPTY).values());
        if (fields.isEmpty()) {
            return Optional.empty();
        }
        int index = RANDOM.nextInt(fields.size());
        VierConnectsField field = (VierConnectsField)fields.get(index);
        return Optional.of(this.moveFactory.createPlaceMarkMove(player.isUsingCrosses(), field.getPosition().getColumn()));
    }

    public String toString() {
        return VierConnectsRandomMoveStrategy.class.getSimpleName();
    }
}

