/*
 * Copyright © 2021-2023 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel24-demo.
 *
 * Ipspiel24-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel24-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel24-demo. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel24.demo.domain.impl;

import java.util.Optional;

import de.fhdw.gaming.ipspiel24.demo.domain.DemoMoveGenerator;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel24.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel24.demo.moves.DemoMove;
import de.fhdw.gaming.ipspiel24.demo.moves.factory.DemoMoveFactory;
import de.fhdw.gaming.ipspiel24.demo.moves.impl.DemoDefaultMoveFactory;

/**
 * Implements the {@link DemoMoveGenerator} interface.
 */
final class DemoMoveGeneratorImpl implements DemoMoveGenerator {

    /**
     * The move factory.
     */
    private final DemoMoveFactory moveFactory = new DemoDefaultMoveFactory();

    @Override
    public Optional<DemoMove> generate(final DemoPlayer player, final DemoState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createNoMove());
    }
}
